/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_FONT_API_
#define SPICE3_FONT_API_

#include "rlTypes.h"

RL_C_API rlFontHandle rlFontGet(rlHandle handle, int32_t fontId);
RL_C_API rlResult rlFontSet(rlHandle handle, rlFontHandle fontHandle);
RL_C_API rlResult rlFontLoad(rlHandle handle, int32_t fontId);
RL_C_API rlResult rlFontStore(rlHandle handle, int32_t fontId);
RL_C_API rlResult rlFontDelete(rlHandle handle, int32_t fontId);
RL_C_API rlResult rlFontSetActive(rlHandle handle, int32_t fontId);

RL_C_API rlFontHandle rlFontAllocate(rlHandle handle, int32_t fontId);
RL_C_API rlResult rlFontAddChar(rlFontHandle handle, char c, rlCommandListHandle listHandle);
RL_C_API rlResult rlFontRemoveChar(rlFontHandle handle, char c);
RL_C_API rlCommandListHandle rlFontGetChar(rlFontHandle handle, char c);
RL_C_API rlResult rlFontClear(rlFontHandle handle);

RL_C_API rlResult rlFontChars(rlFontHandle handle, char* buffer, uint32_t bufferSize, uint32_t* charCount);
RL_C_API rlResult rlFontCharsLen(rlFontHandle handle, uint32_t* charCount);

RL_C_API rlResult rlFontReleaseHandle(rlFontHandle handle);

#endif // _SPICE3_FONT_API_